defmodule Console.Clavier do
  @moduledoc """
  Une simple tâche gérant les entrées clavier.
  Son rôle est simplement d'écouter les entrées standard et les rediriger vers l'interface.
  """

  use Task

  @doc """
  Création du processus.
  """
  def start_link(options) do
    options = Keyword.put(options, :name, :clavier)
    Task.start_link(__MODULE__, :écouter_clavier, options)
  end

  def écouter_clavier(_) do
    entrée_clavier =
      IO.gets("")
      |> String.trim()

    Console.Interface.gérer_entrée(entrée_clavier)
    écouter_clavier(nil)
  end
end
